<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Verify\V2;

use Twilio\Options;
use Twilio\Values;

abstract class VerificationAttemptOptions {
    /**
     * @param \DateTime $dateCreatedAfter Filter verification attempts after this
     *                                    date
     * @param \DateTime $dateCreatedBefore Filter verification attempts befor this
     *                                     date
     * @param string $channelDataTo Destination of a verification
     * @return ReadVerificationAttemptOptions Options builder
     */
    public static function read(\DateTime $dateCreatedAfter = Values::NONE, \DateTime $dateCreatedBefore = Values::NONE, string $channelDataTo = Values::NONE): ReadVerificationAttemptOptions {
        return new ReadVerificationAttemptOptions($dateCreatedAfter, $dateCreatedBefore, $channelDataTo);
    }
}

class ReadVerificationAttemptOptions extends Options {
    /**
     * @param \DateTime $dateCreatedAfter Filter verification attempts after this
     *                                    date
     * @param \DateTime $dateCreatedBefore Filter verification attempts befor this
     *                                     date
     * @param string $channelDataTo Destination of a verification
     */
    public function __construct(\DateTime $dateCreatedAfter = Values::NONE, \DateTime $dateCreatedBefore = Values::NONE, string $channelDataTo = Values::NONE) {
        $this->options['dateCreatedAfter'] = $dateCreatedAfter;
        $this->options['dateCreatedBefore'] = $dateCreatedBefore;
        $this->options['channelDataTo'] = $channelDataTo;
    }

    /**
     * Datetime filter used to query Verification Attempts created after this datetime.
     *
     * @param \DateTime $dateCreatedAfter Filter verification attempts after this
     *                                    date
     * @return $this Fluent Builder
     */
    public function setDateCreatedAfter(\DateTime $dateCreatedAfter): self {
        $this->options['dateCreatedAfter'] = $dateCreatedAfter;
        return $this;
    }

    /**
     * Datetime filter used to query Verification Attempts created before this datetime.
     *
     * @param \DateTime $dateCreatedBefore Filter verification attempts befor this
     *                                     date
     * @return $this Fluent Builder
     */
    public function setDateCreatedBefore(\DateTime $dateCreatedBefore): self {
        $this->options['dateCreatedBefore'] = $dateCreatedBefore;
        return $this;
    }

    /**
     * Destination of a verification. Depending on the type of channel, it could be a phone number in E.164 format or an email address.
     *
     * @param string $channelDataTo Destination of a verification
     * @return $this Fluent Builder
     */
    public function setChannelDataTo(string $channelDataTo): self {
        $this->options['channelDataTo'] = $channelDataTo;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Verify.V2.ReadVerificationAttemptOptions ' . $options . ']';
    }
}